
markup.push({

// MARK: importer replacement blocks

GenericUnknownBlock: {
	// only exists for importer. Substitute VUMeter for any unknown block
	"+": "VUMeterBlock"
},

DoubleGainBlock: {
	// only exists to provide double gain volume for importer
	"+": "GainEffectsBlock",
	gxNodeInitialProperties : { overdrive: 2.0 }  // swap mode
},

SwapChannelsBlock: {
	// only exists to provide default channel tweaker setting for importer
	"+": "ChannelTweakerBlock",
	gxNodeInitialProperties : { tweakMode: 1 }  // swap mode
},

MonomizerBlock: {
	// only exists to provide default channel tweaker setting for importer
	"+": "ChannelTweakerBlock",
	gxNodeInitialProperties : { tweakMode: 2 }  // mono mode
},

// MARK: importer effect -> block mapping

// this dictionary maps both old (probably very old) and newer
// plugin uid's used in AHP, and maps them to AH3 block names
ImporterEffectsMapping : {
	"rogueamoeba.4fx.applicationmixer":			"ApplicationSourceBlock",
	"com.rogueamoeba.4fx.applicationmixer":		"ApplicationSourceBlock",
	"alex_lagutin.4fx.balance":				"BalanceBlock",
	"com.rogueamoeba.4fx.balance":			"BalanceBlock",
	"alex_lagutin.4fx.bass_and_treble":			"BassTrebleBlock",
	"com.rogueamoeba.4fx.bassandtreble":		"BassTrebleBlock",
	"alex_lagutin.4fx.chan_tweaker":			"ChannelTweakerBlock",
	"com.rogueamoeba.4fx.chantweaker":		"ChannelTweakerBlock",
	"alex_lagutin.4fx.device_output":			"AudioDeviceOutputBlock",
	"com.rogueamoeba.4fx.deviceoutput":			"AudioDeviceOutputBlock",
	"alex_lagutin.4fx.double_gain":			"DoubleGainBlock",
	"com.rogueamoeba.4fx.doublegain":		"DoubleGainBlock",
	"alex_lagutin.4fx.eq10":						"Equalizer10Block",
	"com.rogueamoeba.4fx.eq10":					"Equalizer10Block",
	"alex_lagutin.4fx.gain":					"GainEffectsBlock",
	"com.rogueamoeba.4fx.gain":				"GainEffectsBlock",
	"alex_lagutin.4fx.lpf":					"LowPassFilterBlock",
	"com.rogueamoeba.4fx.lpf":				"LowPassFilterBlock",
	"alex_lagutin.4fx.mbar_meters":				"MenuBarMeterBloc",
	"com.rogueamoeba.4fx.mbarmeters":			"MenuBarMeterBloc",
	"alex_lagutin.4fx.mono_enhancer":		"MonoEnhancerBlock",
	"com.rogueamoeba.4fx.monoenhancer":		"MonoEnhancerBlock",
	"alex_lagutin.4fx.monomizer":				"MonomizerBlock",
	"com.rogueamoeba.4fx.monomizer":				"MonomizerBlock",
	"rogue_amoeba.4fx.pause":				"UnknownBlock",
	"com.rogueamoeba.4fx.pause":				"UnknownBlock",
	"rogueamoeba.4fx.pan":					"PanBlock",
	"com.rogueamoeba.4fx.pan":				"PanBlock",
	"alex_lagutin.4fx.reverb":				"ReverbBlock",
	"com.rogueamoeba.4fx.reverb":			"ReverbBlock",
	"alex_lagutin.4fx.swap_channels":			"SwapChannelsBlock",
	"com.rogueamoeba.4fx.swapchannels":			"SwapChannelsBlock",
	"alex_lagutin.4fx.voiceover":			"AudioDeviceInputBlock",
	"com.rogueamoeba.4fx.voiceover":			"AudioDeviceInputBlock",
	"alex_lagutin.4fx.vu_meters":				"VUMeterBlock",
	"com.rogueamoeba.4fx.vumeters":				"VUMeterBlock"
}


})
